/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.config.Config;
import com.tradevan.commons.config.ConfigFactory;
import com.tradevan.taurus.text.TextRuntimeException;
import java.text.MessageFormat;
import java.util.Properties;

public class TextConfig {
    public static final String DEFAULT_TEXT_READER = "com.tradevan.taurus.text.TextReader";
    public static final String DEFAULT_TEXT_WRITER = "com.tradevan.taurus.text.TextWriter";
    private static final String _CONFIG_FILE = "/conf/taurus_text.xml";
    private static final String _READERS_DEFAULT = "readers/@default";
    private static final String _WRITERS_DEFAULT = "writers/@default";
    private static final String _READERS = "readers/reader/@id";
    private static final String _READER_CLASS = "readers/reader[@id=''{0}'']/@class";
    private static final String _READER_PROPERTIES = "readers/reader[@id=''{0}'']/property/@name";
    private static final String _READER_PROPERTY = "readers/reader[@id=''{0}'']/property[@name=''{1}'']/@value";
    private static final String _WRITERS = "writers/writer/@id";
    private static final String _WRITER_CLASS = "writers/writer[@id=''{0}'']/@class";
    private static final String _WRITER_PROPERTIES = "writers/writer[@id=''{0}'']/property/@name";
    private static final String _WRITER_PROPERTY = "writers/writer[@id=''{0}'']/property[@name=''{1}'']/@value";
    private static final String _PROCESSORS = "text-processor/processor/@id";
    private static final String _PROCESSOR_CLASS = "text-processor/processor[@id=''{0}'']/@class";
    private static final String _PROCESSOR_PROPERTIES = "text-processor/processor[@id=''{0}'']/property/@name";
    private static final String _PROCESSOR_PROPERTY = "text-processor/processor[@id=''{0}'']/property[@name=''{1}'']/@value";
    private static TextConfig me = null;
    private Config config = null;
    static /* synthetic */ Class class$0;

    private TextConfig() {
        this.config = ConfigFactory.newConfig((String)_CONFIG_FILE);
        if (this.config != null) {
            this.config.enableXpath(true);
        }
    }

    public TextConfig(String conf) {
        this.config = ConfigFactory.newConfig((String)conf);
        if (this.config == null) {
            throw new TextRuntimeException("Config file '" + conf + "' was not found!");
        }
        this.config.enableXpath(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextConfig getInstance() {
        if (me != null) return me;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.tradevan.taurus.text.TextConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (me != null) return me;
            me = new TextConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    public String getDefaultReaderId() {
        return this.getString(_READERS_DEFAULT);
    }

    public String getDefaultWriterId() {
        return this.getString(_WRITERS_DEFAULT);
    }

    public String[] getReaders() {
        return this.getStringArray(_READERS);
    }

    public String getReaderClass(String id) {
        return this.getString(_READER_CLASS, id);
    }

    public Properties getReaderProperties(String id) {
        return this.getProperties(_READER_PROPERTIES, _READER_PROPERTY, id);
    }

    public String getReaderProperty(String id, String propName) {
        Object[] str = new String[]{id, propName};
        return this.getString(MessageFormat.format(_READER_PROPERTY, str));
    }

    public String[] getWriters() {
        return this.getStringArray(_WRITERS);
    }

    public String getWriterClass(String id) {
        return this.getString(_WRITER_CLASS, id);
    }

    public Properties getWriterProperties(String id) {
        return this.getProperties(_WRITER_PROPERTIES, _WRITER_PROPERTY, id);
    }

    public String getWriterProperty(String id, String propName) {
        Object[] str = new String[]{id, propName};
        return this.getString(MessageFormat.format(_WRITER_PROPERTY, str));
    }

    public String[] getProcessors() {
        return this.getStringArray(_PROCESSORS);
    }

    public String getProcessorClass(String id) {
        return this.getString(_PROCESSOR_CLASS, id);
    }

    public Properties getProcessorProperties(String id) {
        return this.getProperties(_PROCESSOR_PROPERTIES, _PROCESSOR_PROPERTY, id);
    }

    private String getString(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getString(key);
    }

    private String getString(String key, String str) {
        if (this.config == null) {
            return null;
        }
        Object[] s = new Object[]{str};
        return this.config.getString(MessageFormat.format(key, s));
    }

    private String[] getStringArray(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getStringArray(key);
    }

    private Properties getProperties(String key1, String key2, String id) {
        if (this.config == null) {
            return null;
        }
        Properties prop = new Properties();
        Object[] paramId = new Object[]{id};
        String[] propName = this.config.getStringArray(MessageFormat.format(key1, paramId));
        Object[] paramProp = new String[]{id, ""};
        int i = 0;
        while (i < propName.length) {
            paramProp[1] = propName[i];
            String xpath = MessageFormat.format(key2, paramProp);
            prop.setProperty(propName[i], this.config.getString(xpath));
            ++i;
        }
        return prop;
    }
}

