/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectStateUtils {
    private static final Log log = LogFactory.getLog((Class)ObjectStateUtils.class);
    public static boolean EMPTY_OBJECT = false;
    public static boolean ACTIVE_OBJECT = true;
    public static String LAST_ENTRY = "LAST_OBJ";
    public static String EMPTY_MARKER = "EMPTY_OBJ";
    public static String NULL_OBJECT = "NULL_OBJ";
    public static final String UNSUPPORTED_SUID = "Serialization version ID is not supported.";
    public static final String UNSUPPORTED_REVID = "Revision ID is not supported.";
    public static final String OBJ_SAVE_PROBLEM = "The object could not be saved to the output stream.  The object may or may not be important for processing the message when it is restored. Look at how the object is to be used during message processing.";
    public static final String OBJ_RESTORE_PROBLEM = "The object could not be restored from the input stream.  The object may or may not be important for processing the message when it is restored. Look at how the object is to be used during message processing.";
    public static Hashtable NotSerializableList = new Hashtable();

    public static void writeString(ObjectOutput out, String str, String desc) throws IOException {
        if (str != null) {
            String str_desc = str.getClass().getName();
            out.writeUTF(str_desc);
            out.writeBoolean(ACTIVE_OBJECT);
            out.writeObject(str);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeString(): ACTIVE string: str_desc [" + str_desc + "]    string [" + str + "]   desc [" + desc + "]"));
            }
        } else {
            out.writeUTF(desc);
            out.writeBoolean(EMPTY_OBJECT);
        }
    }

    public static String readString(ObjectInput in, String desc) throws IOException, ClassNotFoundException {
        String str = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            str = (String)in.readObject();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readString(): [" + desc + "]  returning  [" + str + "]  for  saved [" + str_desc + "]"));
        }
        return str;
    }

    public static void writeObject(ObjectOutput out, Object obj, String desc) throws IOException {
        IOException returned_exception = null;
        if (obj != null) {
            block7: {
                String objClassName = obj.getClass().getName();
                String fullDesc = desc + ":" + objClassName;
                out.writeUTF(fullDesc);
                try {
                    ByteArrayOutputStream test_outBuffer = new ByteArrayOutputStream();
                    ObjectOutputStream test_objOut = new ObjectOutputStream(test_outBuffer);
                    test_objOut.writeObject(obj);
                    test_objOut.close();
                    test_outBuffer.close();
                    byte[] data = test_outBuffer.toByteArray();
                    out.writeBoolean(ACTIVE_OBJECT);
                    out.writeObject(data);
                }
                catch (NotSerializableException nse2) {
                    returned_exception = nse2;
                    ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeObject()", OBJ_SAVE_PROBLEM);
                }
                catch (IOException exc2) {
                    returned_exception = exc2;
                    if (!log.isTraceEnabled()) break block7;
                    log.trace((Object)("ObjectStateUtils:writeObject(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc2.getClass().getName() + " : " + exc2.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc2);
                }
            }
            if (returned_exception != null) {
                out.writeBoolean(EMPTY_OBJECT);
                throw returned_exception;
            }
        } else {
            out.writeUTF(desc);
            out.writeBoolean(EMPTY_OBJECT);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:writeObject(): EMPTY Object [" + desc + "]  "));
            }
        }
    }

    public static Object readObject(ObjectInput in, String desc) throws IOException, ClassNotFoundException {
        Object obj = null;
        byte[] data = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            data = (byte[])in.readObject();
            ByteArrayInputStream test_inBuffer = new ByteArrayInputStream(data);
            ObjectInputStream test_objIn = new ObjectInputStream(test_inBuffer);
            obj = test_objIn.readObject();
            test_objIn.close();
            test_inBuffer.close();
        }
        String value = "null";
        if (obj != null) {
            value = obj.getClass().getName();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readObject(): [" + desc + "]  returning  [" + value + "]   for saved [" + str_desc + "]"));
        }
        return obj;
    }

    public static void writeArrayList(ObjectOutput out, ArrayList al, String desc) throws IOException {
        int savedListSize = 0;
        out.writeUTF(desc);
        out.writeBoolean(al == null ? EMPTY_OBJECT : ACTIVE_OBJECT);
        if (al != null) {
            Iterator i = al.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                try {
                    ByteArrayOutputStream test_outBuffer = new ByteArrayOutputStream();
                    ObjectOutputStream test_objOut = new ObjectOutputStream(test_outBuffer);
                    test_objOut.writeObject(obj);
                    test_objOut.flush();
                    byte[] data = test_outBuffer.toByteArray();
                    out.writeBoolean(ACTIVE_OBJECT);
                    out.writeObject(data);
                    test_objOut.close();
                    test_outBuffer.close();
                    ++savedListSize;
                }
                catch (NotSerializableException nse2) {
                    ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeArrayList()", OBJ_SAVE_PROBLEM);
                }
                catch (Exception exc) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:writeArrayList(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                }
            }
            out.writeBoolean(EMPTY_OBJECT);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:writeArrayList(): List [" + desc + "]   members saved [" + savedListSize + "]"));
        }
    }

    public static ArrayList readArrayList(ObjectInput in, String desc) throws IOException {
        ArrayList<Object> list = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            list = new ArrayList<Object>();
            while (in.readBoolean()) {
                try {
                    byte[] data = (byte[])in.readObject();
                    ByteArrayInputStream test_inBuffer = new ByteArrayInputStream(data);
                    ObjectInputStream test_objIn = new ObjectInputStream(test_inBuffer);
                    Object obj = test_objIn.readObject();
                    test_objIn.close();
                    test_inBuffer.close();
                    list.add(obj);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  index [" + list.size() + "]  for saved [" + str_desc + "]"));
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  object index [" + list.size() + "]   for saved [" + str_desc + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            int size = list == null ? -1 : list.size();
            log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  returning  [listsize=" + size + "]  for saved [" + str_desc + "]"));
        }
        return list;
    }

    public static void writeHashMap(ObjectOutput out, HashMap map, String desc) throws IOException {
        int savedMapSize = 0;
        out.writeUTF(desc);
        out.writeBoolean(map == null ? EMPTY_OBJECT : ACTIVE_OBJECT);
        if (map != null) {
            Set keyset = map.keySet();
            Iterator i = keyset.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = map.get(key);
                try {
                    ByteArrayOutputStream pair_outBuffer = new ByteArrayOutputStream();
                    ObjectOutputStream pair_objOut = new ObjectOutputStream(pair_outBuffer);
                    pair_objOut.writeObject(key);
                    pair_objOut.writeObject(value);
                    pair_objOut.flush();
                    byte[] data = pair_outBuffer.toByteArray();
                    out.writeBoolean(ACTIVE_OBJECT);
                    out.writeObject(data);
                    pair_objOut.close();
                    pair_outBuffer.close();
                    ++savedMapSize;
                }
                catch (NotSerializableException nse2) {
                    ObjectStateUtils.traceNotSerializable(key, nse2, desc, "ObjectStateUtils.writeHashMap() map key", OBJ_SAVE_PROBLEM);
                }
                catch (Exception exc) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:writeHashMap(): map key [" + key.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                }
            }
            out.writeBoolean(EMPTY_OBJECT);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:writeHashMap(): map [" + desc + "]   members saved [" + savedMapSize + "]"));
        }
    }

    public static HashMap readHashMap(ObjectInput in, String desc) throws IOException {
        int size;
        int obtainedMapSize = 0;
        HashMap<Object, Object> map = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            map = new HashMap<Object, Object>();
            while (in.readBoolean()) {
                Object key = null;
                Object value = null;
                try {
                    byte[] data = (byte[])in.readObject();
                    ByteArrayInputStream test_inBuffer = new ByteArrayInputStream(data);
                    ObjectInputStream test_objIn = new ObjectInputStream(test_inBuffer);
                    key = test_objIn.readObject();
                    value = test_objIn.readObject();
                    test_objIn.close();
                    test_inBuffer.close();
                    map.put(key, value);
                    ++obtainedMapSize;
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  object pair index [" + obtainedMapSize + "]   for saved [" + str_desc + "]"));
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  object pair index [" + obtainedMapSize + "]   for saved [" + str_desc + "] ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                }
            }
        }
        int n = size = map == null ? -1 : map.size();
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:readHashMap(): [" + desc + "]  returning  [mapsize=" + size + "]    for saved [" + str_desc + "]"));
        }
        return map;
    }

    public static void writeLinkedList(ObjectOutput out, LinkedList objlist, String desc) throws IOException {
        int savedListSize = 0;
        out.writeUTF(desc);
        out.writeBoolean(objlist == null ? EMPTY_OBJECT : ACTIVE_OBJECT);
        if (objlist != null) {
            Iterator i = objlist.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                try {
                    ByteArrayOutputStream test_outBuffer = new ByteArrayOutputStream();
                    ObjectOutputStream test_objOut = new ObjectOutputStream(test_outBuffer);
                    test_objOut.writeObject(obj);
                    test_objOut.flush();
                    byte[] data = test_outBuffer.toByteArray();
                    out.writeBoolean(ACTIVE_OBJECT);
                    out.writeObject(data);
                    test_objOut.close();
                    test_outBuffer.close();
                    ++savedListSize;
                }
                catch (NotSerializableException nse2) {
                    ObjectStateUtils.traceNotSerializable(obj, nse2, desc, "ObjectStateUtils.writeLinkedList()", OBJ_SAVE_PROBLEM);
                }
                catch (Exception exc) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:writeLinkedList(): object[" + obj.getClass().getName() + "]  ***Exception***  [" + exc.getClass().getName() + " : " + exc.getMessage() + "]  " + OBJ_SAVE_PROBLEM), (Throwable)exc);
                }
            }
            out.writeBoolean(EMPTY_OBJECT);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:writeLinkedList(): List [" + desc + "]   members saved [" + savedListSize + "]"));
        }
    }

    public static LinkedList readLinkedList(ObjectInput in, String desc) throws IOException {
        LinkedList<Object> list = null;
        String str_desc = in.readUTF();
        boolean isActive = in.readBoolean();
        if (isActive == ACTIVE_OBJECT) {
            list = new LinkedList<Object>();
            while (in.readBoolean()) {
                try {
                    byte[] data = (byte[])in.readObject();
                    ByteArrayInputStream test_inBuffer = new ByteArrayInputStream(data);
                    ObjectInputStream test_objIn = new ObjectInputStream(test_inBuffer);
                    Object obj = test_objIn.readObject();
                    test_objIn.close();
                    test_inBuffer.close();
                    list.add(obj);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  index [" + list.size() + "]  for saved [" + str_desc + "]"));
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  object index [" + list.size() + "]   for saved [" + str_desc + "]  ***Exception***  [" + ex.getClass().getName() + " : " + ex.getMessage() + "]  " + OBJ_RESTORE_PROBLEM), (Throwable)ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            int size = list == null ? -1 : list.size();
            log.trace((Object)("ObjectStateUtils:readArrayList(): [" + desc + "]  returning  [listsize=" + size + "]  for saved [" + str_desc + "]"));
        }
        return list;
    }

    public static AxisOperation findOperation(AxisConfiguration axisConfig, String opClassName, QName opQName) {
        HashMap services = axisConfig.getServices();
        Iterator its = services.values().iterator();
        while (its.hasNext()) {
            AxisService service = (AxisService)its.next();
            Iterator ito = service.getOperations();
            while (ito.hasNext()) {
                AxisOperation operation = (AxisOperation)ito.next();
                String tmpOpName = operation.getClass().getName();
                QName tmpOpQName = operation.getName();
                if (!tmpOpName.equals(opClassName) || !tmpOpQName.equals(opQName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
                }
                return operation;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): [" + opClassName + "]   [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisOperation findOperation(AxisService service, String opClassName, QName opQName) {
        if (service == null) {
            return null;
        }
        Iterator ito = service.getOperations();
        while (ito.hasNext()) {
            AxisOperation operation = (AxisOperation)ito.next();
            String tmpOpName = operation.getClass().getName();
            QName tmpOpQName = operation.getName();
            if (!tmpOpName.equals(opClassName) || !tmpOpQName.equals(opQName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findOperation(service): returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
            }
            return operation;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(service): [" + opClassName + "]   [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisService findService(AxisConfiguration axisConfig, String serviceClassName, String serviceName) {
        HashMap services = axisConfig.getServices();
        Iterator its = services.values().iterator();
        while (its.hasNext()) {
            AxisService service = (AxisService)its.next();
            String tmpServClassName = service.getClass().getName();
            String tmpServName = service.getName();
            if (!tmpServClassName.equals(serviceClassName) || !tmpServName.equals(serviceName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findService(): returning  [" + serviceClassName + "]   [" + serviceName + "]"));
            }
            return service;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findService(): [" + serviceClassName + "]   [" + serviceName + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisServiceGroup findServiceGroup(AxisConfiguration axisConfig, String serviceGrpClassName, String serviceGrpName) {
        Iterator its = axisConfig.getServiceGroups();
        while (its.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)its.next();
            String tmpSGClassName = serviceGroup.getClass().getName();
            String tmpSGName = serviceGroup.getServiceGroupName();
            if (!tmpSGClassName.equals(serviceGrpClassName)) continue;
            boolean found = false;
            if (tmpSGName == null && serviceGrpName == null) {
                found = true;
            } else if (tmpSGName != null && tmpSGName.equals(serviceGrpName)) {
                found = true;
            }
            if (!found) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findServiceGroup(): returning  [" + serviceGrpClassName + "]   [" + serviceGrpName + "]"));
            }
            return serviceGroup;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findServiceGroup(): [" + serviceGrpClassName + "]   [" + serviceGrpName + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisMessage findMessage(AxisOperation op, String msgName, String msgElementName) {
        boolean matching;
        if (op == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - no AxisOperation"));
            }
            return null;
        }
        if (msgName == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - message name is not set"));
            }
            return null;
        }
        String tmpName = null;
        String tmpElementName = null;
        AxisMessage out = null;
        try {
            out = op.getMessage("Out");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (out != null) {
            tmpName = out.getName();
            QName tmpQout = out.getElementQName();
            if (tmpQout != null) {
                tmpElementName = tmpQout.toString();
            }
        }
        if (matching = ObjectStateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning OUT message  [" + msgName + "]  [" + msgElementName + "] "));
            }
            return out;
        }
        AxisMessage in = null;
        try {
            in = op.getMessage("In");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (in != null) {
            tmpName = in.getName();
            QName tmpQin = in.getElementQName();
            if (tmpQin != null) {
                tmpElementName = tmpQin.toString();
            }
        } else {
            tmpName = null;
            tmpElementName = null;
        }
        matching = ObjectStateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName);
        if (matching) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning IN message [" + msgName + "]  [" + msgElementName + "] "));
            }
            return in;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null]"));
        }
        return null;
    }

    private static boolean matchMessageNames(String name1, String elementName1, String name2, String elementName2) {
        if (name1 != null && name2 != null && name1.equals(name2)) {
            if (elementName1 == null && elementName2 == null) {
                return true;
            }
            return elementName1 != null && elementName2 != null && elementName1.equals(elementName2);
        }
        return false;
    }

    public static Object findHandler(ArrayList existingHandlers, MetaDataEntry metaDataEntry) {
        String title = "ObjectStateUtils:findHandler(): ";
        String handlerClassName = metaDataEntry.getClassName();
        String qNameAsString = metaDataEntry.getQNameAsString();
        for (int i = 0; i < existingHandlers.size(); ++i) {
            if (existingHandlers.get(i) == null) continue;
            String tmpClassName = existingHandlers.get(i).getClass().getName();
            String tmpName = ((Handler)existingHandlers.get(i)).getName().toString();
            if (!tmpClassName.equals(handlerClassName) || !tmpName.equals(qNameAsString)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)(title + " [" + handlerClassName + "]  name [" + qNameAsString + "]  returned"));
            }
            return (Handler)existingHandlers.get(i);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(title + " [" + handlerClassName + "]  name [" + qNameAsString + "] was not found in the existingHandlers list"));
        }
        return null;
    }

    public static TransportListener findTransportListener(AxisConfiguration axisConfig, String listenerClassName) {
        HashMap transportsIn = axisConfig.getTransportsIn();
        Collection values = transportsIn.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            TransportInDescription ti = (TransportInDescription)i.next();
            TransportListener tl = ti.getReceiver();
            String tlClassName = tl.getClass().getName();
            if (!tlClassName.equals(listenerClassName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findTransportListener():  [" + listenerClassName + "]  returned"));
            }
            return tl;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:findTransportListener(): returning  [null]");
        }
        return null;
    }

    public static boolean isEquivalent(ArrayList a1, ArrayList a2, boolean strict) {
        if (a1 != null && a2 != null) {
            int size2;
            int size1 = a1.size();
            if (size1 != (size2 = a2.size())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - size mismatch [" + size1 + "] != [" + size2 + "]"));
                }
                return false;
            }
            if (strict) {
                return a1.equals(a2);
            }
            Iterator i1 = a1.iterator();
            while (i1.hasNext()) {
                Object obj1 = i1.next();
                if (a2.contains(obj1)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch with element [" + obj1.getClass().getName() + "] "));
                }
                return false;
            }
            return true;
        }
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null && a2 == null) {
            return a1.size() == 0;
        }
        if (a1 == null && a2 != null) {
            return a2.size() == 0;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch in lists");
        }
        return false;
    }

    public static boolean isEquivalent(Map m1, Map m2, boolean strict) {
        if (m1 != null && m2 != null) {
            int size2;
            if (strict) {
                return ((Object)m1).equals(m2);
            }
            int size1 = m1.size();
            if (size1 != (size2 = m2.size())) {
                return false;
            }
            Iterator it1 = m1.keySet().iterator();
            while (it1.hasNext()) {
                Object key1 = it1.next();
                if (m2.containsKey(key1)) continue;
                return false;
            }
            return true;
        }
        return m1 == null && m2 == null;
    }

    public static boolean isEquivalent(LinkedList l1, LinkedList l2) {
        if (l1 != null && l2 != null) {
            return l1.equals(l2);
        }
        return l1 == null && l2 == null;
    }

    public static void traceNotSerializable(Object obj, NotSerializableException nse, String objDesc, String methodName, String desc) {
        String objName;
        if (!log.isTraceEnabled()) {
            return;
        }
        if (obj != null && NotSerializableList.get(objName = obj.getClass().getName()) == null) {
            Integer counter = new Integer(1);
            NotSerializableList.put(objName, counter);
            log.trace((Object)("ObjectStateUtils: ***NotSerializableException*** [" + nse.getMessage() + "] in method [" + methodName + "] for object [" + objName + "]  associated with [" + objDesc + "].  " + desc));
        }
    }
}

