/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterIncludeImpl
implements ParameterInclude,
Externalizable {
    private static final Log log = LogFactory.getLog((Class)ParameterIncludeImpl.class);
    private static final String myClassName = "ParameterIncludeImpl";
    private static final long serialVersionUID = 8153736719090126891L;
    private static final int REVISION_1 = 1;
    private static final int revisionID = 1;
    protected final HashMap parameters = new HashMap();

    public void addParameter(Parameter param) {
        if (param != null) {
            this.parameters.put(param.getName(), param);
        }
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void deserializeParameters(OMElement parameters) throws AxisFault {
        Iterator iterator = parameters.getChildrenWithName(new QName("parameter"));
        while (iterator.hasNext()) {
            OMElement parameterElement = (OMElement)iterator.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paraName = parameterElement.getAttribute(new QName("name"));
            parameter.setName(paraName.getAttributeValue());
            OMElement paraValue = parameterElement.getFirstElement();
            if (paraValue != null) {
                parameter.setValue(parameterElement);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue(paratextValue);
                parameter.setParameterType(1);
            }
            OMAttribute paraLocked = parameterElement.getAttribute(new QName("locked"));
            if (paraLocked != null) {
                String lockedValue = paraLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            this.addParameter(parameter);
        }
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        Collection col = this.parameters.values();
        ArrayList<Parameter> para_list = new ArrayList<Parameter>();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            para_list.add(parameter);
        }
        return para_list;
    }

    public boolean isParameterLocked(String parameterName) {
        return false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(8153736719090126891L);
        out.writeInt(1);
        ObjectStateUtils.writeHashMap(out, this.parameters, "ParameterIncludeImpl.parameters");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("ParameterIncludeImpl:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8153736719090126891L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 1) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        HashMap tmp = ObjectStateUtils.readHashMap(in, "ParameterIncludeImpl.parameters");
        if (tmp != null) {
            if (this.parameters != null) {
                this.parameters.putAll(tmp);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"ParameterIncludeImpl:readExternal():  WARNING: parameters doesnot have a defined HashMap ");
            }
        }
    }
}

