/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;

public class AxisMessage
extends AxisDescription {
    private ArrayList handlerChain;
    private String name;
    private ArrayList soapHeaders = new ArrayList();
    private QName elementQname;
    private String direction;
    private String messagePartName;
    private ArrayList modulerefs;
    private String partName = "parameters";
    private boolean wrapped = true;

    public String getMessagePartName() {
        return this.messagePartName;
    }

    public void setMessagePartName(String messagePartName) {
        this.messagePartName = messagePartName;
    }

    public AxisMessage() {
        this.handlerChain = new ArrayList();
        this.modulerefs = new ArrayList();
    }

    public ArrayList getMessageFlow() {
        return this.handlerChain;
    }

    public boolean isParameterLocked(String parameterName) {
        boolean locked = false;
        if (this.getParent() != null) {
            locked = this.getParent().isParameterLocked(parameterName);
        }
        if (locked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setMessageFlow(ArrayList operationFlow) {
        this.handlerChain = operationFlow;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public QName getElementQName() {
        return this.elementQname;
    }

    public void setElementQName(QName element) {
        this.elementQname = element;
    }

    public Object getKey() {
        return this.elementQname;
    }

    public XmlSchemaElement getSchemaElement() {
        XmlSchemaElement xmlSchemaElement = null;
        AxisService service = this.getAxisOperation().getAxisService();
        ArrayList schemas = service.getSchema();
        Iterator schemaIter = schemas.iterator();
        while (schemaIter.hasNext() && (xmlSchemaElement = this.getSchemaElement((XmlSchema)schemaIter.next())) == null) {
        }
        return xmlSchemaElement;
    }

    private XmlSchemaElement getSchemaElement(XmlSchema schema) {
        XmlSchemaObjectCollection includes;
        XmlSchemaElement xmlSchemaElement = null;
        if (schema != null && (xmlSchemaElement = schema.getElementByName(this.elementQname)) == null && (includes = schema.getIncludes()) != null) {
            Iterator includesIter = includes.getIterator();
            while (includesIter.hasNext()) {
                XmlSchema schema1;
                Object object = includesIter.next();
                if (object instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)object).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1);
                }
                if (object instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)object).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1);
                }
                if (xmlSchemaElement == null) continue;
                break;
            }
        }
        return xmlSchemaElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getExtensibilityAttributes() {
        return new ArrayList(0);
    }

    public void addSoapHeader(SOAPHeaderMessage soapHeaderMessage) {
        this.soapHeaders.add(soapHeaderMessage);
    }

    public ArrayList getSoapHeaders() {
        return this.soapHeaders;
    }

    public void onEngage(AxisModule axisModule, AxisDescription engager) throws AxisFault {
        PhaseResolver phaseResolver = new PhaseResolver(this.getAxisConfiguration());
        phaseResolver.engageModuleToMessage(this, axisModule);
    }

    public ArrayList getModulerefs() {
        return this.modulerefs;
    }

    public void addModuleRefs(String moduleName) {
        this.modulerefs.add(moduleName);
    }

    public AxisOperation getAxisOperation() {
        return (AxisOperation)this.parent;
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }
}

